/*
 * Decompiled with CFR 0.152.
 */
package com.c2h6s.etshtinker.tools.stats;

import com.c2h6s.etshtinker.etshtinker;
import com.c2h6s.etshtinker.init.etshtinkerToolStats;
import com.c2h6s.etshtinker.util.SlashColor;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import slimeknights.mantle.data.loadable.field.RecordField;
import slimeknights.mantle.data.loadable.primitive.FloatLoadable;
import slimeknights.mantle.data.loadable.record.RecordLoadable;
import slimeknights.tconstruct.library.materials.stats.IMaterialStats;
import slimeknights.tconstruct.library.materials.stats.MaterialStatType;
import slimeknights.tconstruct.library.materials.stats.MaterialStatsId;
import slimeknights.tconstruct.library.tools.stat.IToolStat;
import slimeknights.tconstruct.library.tools.stat.ModifierStatsBuilder;

public record PlasmaGeneratorMaterialStats(float damageMultiplier, float criticalRate, float fluidEfficiency, float slashColor) implements IMaterialStats
{
    public static final MaterialStatsId ID = new MaterialStatsId("etshtinker", "plasma_generator");
    public static final MaterialStatType<PlasmaGeneratorMaterialStats> TYPE = new MaterialStatType(ID, (IMaterialStats)new PlasmaGeneratorMaterialStats(0.0f, 0.0f, 1.0f, 0.0f), RecordLoadable.create((RecordField)FloatLoadable.ANY.defaultField("damagemultiplier", (Object)Float.valueOf(0.0f), true, PlasmaGeneratorMaterialStats::damageMultiplier), (RecordField)FloatLoadable.ANY.defaultField("criticalrate", (Object)Float.valueOf(0.0f), true, PlasmaGeneratorMaterialStats::criticalRate), (RecordField)FloatLoadable.ANY.defaultField("fluidefficiency", (Object)Float.valueOf(1.0f), true, PlasmaGeneratorMaterialStats::fluidEfficiency), (RecordField)FloatLoadable.ANY.defaultField("slash_color", (Object)Float.valueOf(0.0f), true, PlasmaGeneratorMaterialStats::slashColor), PlasmaGeneratorMaterialStats::new));
    private static final String DAMAGE_PREFIX = IMaterialStats.makeTooltipKey((ResourceLocation)etshtinker.getResourceLoc("damagemultiplier"));
    private static final String CRITICAL_PREFIX = IMaterialStats.makeTooltipKey((ResourceLocation)etshtinker.getResourceLoc("criticalrate"));
    private static final String EFFICIENCY_PREFIX = IMaterialStats.makeTooltipKey((ResourceLocation)etshtinker.getResourceLoc("fluidefficiency"));
    private static final String COLOR_PREFIX = IMaterialStats.makeTooltipKey((ResourceLocation)etshtinker.getResourceLoc("slashcolor"));
    private static final List<Component> DESCRIPTION = ImmutableList.of((Object)IMaterialStats.makeTooltip((ResourceLocation)etshtinker.getResourceLoc("plasma_generator.damagemultiplier.description")), (Object)IMaterialStats.makeTooltip((ResourceLocation)etshtinker.getResourceLoc("plasma_generator.criticalrate.description")), (Object)IMaterialStats.makeTooltip((ResourceLocation)etshtinker.getResourceLoc("plasma_generator.fluidefficiency.description")), (Object)IMaterialStats.makeTooltip((ResourceLocation)etshtinker.getResourceLoc("plasma_generator.slashcolor.description")));

    public MaterialStatType<?> getType() {
        return TYPE;
    }

    public MaterialStatsId getIdentifier() {
        return ID;
    }

    public List<Component> getLocalizedInfo() {
        ArrayList info = Lists.newArrayList();
        info.add(IToolStat.formatColoredBonus((String)DAMAGE_PREFIX, (float)this.damageMultiplier));
        info.add(IToolStat.formatColoredBonus((String)CRITICAL_PREFIX, (float)this.criticalRate));
        info.add(IToolStat.formatColoredBonus((String)EFFICIENCY_PREFIX, (float)this.fluidEfficiency));
        info.add(Component.m_237115_((String)"etshtinker.tooltip.slashcolor_index").m_130946_(":").m_7220_((Component)Component.m_237115_((String)SlashColor.getSlashColorStr((int)this.slashColor))));
        return info;
    }

    public List<Component> getLocalizedDescriptions() {
        return DESCRIPTION;
    }

    public void apply(ModifierStatsBuilder builder, float v) {
        etshtinkerToolStats.CRITICAL_RATE.update(builder, Float.valueOf(this.criticalRate));
        etshtinkerToolStats.FLUID_EFFICIENCY.update(builder, Float.valueOf(this.fluidEfficiency));
        etshtinkerToolStats.DAMAGEMULTIPLIER.update(builder, Float.valueOf(this.damageMultiplier));
        etshtinkerToolStats.SLASH_COLOR.update(builder, Float.valueOf(this.slashColor));
    }
}

